type
  TAppBuilder=class(TMainWorkForm)
  private
   FHadStackOverflow   :Boolean;
   FMousePos           :TPoint;
   FWndBeforeRun       :HWND;
   FToolbarStreams     :TStrings;
   FToolbars           :TToolbarArray;
   FDragObject         :TDragDockObject;
   FRunMode            :TOTARunMode;
   FNewMenuActions     :TList;
   FDefaultAppGalleryItem:string;
   FInUpdateMenuBar    :Boolean;
   FInLoadMenu         :Boolean;
   FCustomizeToolbarNotifier:INTACustomizeToolbarNotifier;
   FCustomizeToolbarNotifiers:IInterfaceList;
   FCustomizing        :Boolean;
   FMenuUpdateCount    :Integer;
   FUpdateMenus        :Boolean;
   FNoProjectLoad      :Boolean;
   FShowOTAMenuNames   :Boolean;
   FWorkingSetOptimized:Boolean;
   FCommandLineParsed  :Boolean;
   FDDEStartupShellCommand:string;
   FDDEWndHandle       :Integer;
   FOnException        :TExceptionEvent;
   FPersonalityIconIndecies::TAppBuilder.:1;
   FPendingDesktopClick:Boolean;
   FOldLocation        :TRect;
   FHelpSystem         :IHelpSystem;
   FRunClock           :TStopwatch;
   FCheckingLicenses   :Boolean;
   FLocaleCheckClock   :TStopwatch;
   FDesktopComboBoxes  :TList<IDEDesktopComboBox.TDesktopComboBox>;
   FAutoSave           :Boolean;
   FDeskSection        :string;
   FLocked             :Boolean;
   FLoadedFromDesktop  :Boolean;
   FSaveStateNecessary :Boolean;
   FWindowPlacement    :tagWINDOWPLACEMENT;
   FWindowPlacementDirty:Boolean;
   FActiveControl      :TWinControl;
   FFocusedControl     :TWinControl;
   FBorderIcons        :TBorderIcons;
   FBorderStyle        :TFormBorderStyle;
   FWindowState        :TWindowState;
   FShowAction         :TShowAction;
   FKeyPreview         :Boolean;
   FActive             :Boolean;
   FFormStyle          :TFormStyle;
   FPosition           :TPosition;
   FDefaultMonitor     :TDefaultMonitor;
   FTileMode           :TTileMode;
   FDropTarget         :Boolean;
   FPrintScale         :TPrintScale;
   FCanvas             :TControlCanvas;
   FHelpFile           :string;
   FIcon               :TIcon;
   FInCMParentBiDiModeChanged:Boolean;
   FMenu               :TMainMenu;
   FModalResult        :TModalResult;
   FDesigner           :IDesignerHook;
   FWindowMenu         :TMenuItem;
   FPixelsPerInch      :Integer;
   FObjectMenuItem     :TMenuItem;
   FOleForm            :IOleForm;
   FClientWidth        :Integer;
   FClientHeight       :Integer;
   FTextHeight         :Integer;
   FDefClientProc      :Pointer;
   FActiveOleControl   :TWinControl;
   FSavedBorderStyle   :TFormBorderStyle;
   FOnActivate         :TNotifyEvent;
   FOnClose            :TCloseEvent;
   FOnCloseQuery       :TCloseQueryEvent;
   FOnDeactivate       :TNotifyEvent;
   FOnHelp             :THelpEvent;
   FOnHide             :TNotifyEvent;
   FOnPaint            :TNotifyEvent;
   FOnShortCut         :TShortCutEvent;
   FOnShow             :TNotifyEvent;
   FOnCreate           :TNotifyEvent;
   FOnDestroy          :TNotifyEvent;
   FAlphaBlend         :Boolean;
   FAlphaBlendValue    :Byte;
   FPopupChildren      :TList;
   FPopupMode          :TPopupMode;
   FPopupParent        :TCustomForm;
   FRecreateChildren   :TList;
   FPopupWnds          :TPopupWndArray;
   FInternalPopupParent:TCustomForm;
   FInternalPopupParentWnd:HWND;
   FScreenSnap         :Boolean;
   FSnapBuffer         :Integer;
   FTransparentColor   :Boolean;
   FTransparentColorValue:TColor;
   FCreatingMainForm   :Boolean;
   FGlassFrame         :TGlassFrame;
   FRefreshGlassFrame  :Boolean;
   FOldCreateOrder     :Boolean;
   FClientHandle       :HWND;
   FClientInstance     :Pointer;
   FAutoRangeCount     :Integer;
   FAutoScroll         :Boolean;
   FHorzScrollBar      :TControlScrollBar;
   FPanPoint           :TPoint;
   FUpdatingScrollBars :Boolean;
   FVertScrollBar      :TControlScrollBar;
   FAlignControlList   :TList;
   FAlignLevel         :Word;
   FBevelEdges         :TBevelEdges;
   FBevelInner         :TBevelCut;
   FBevelOuter         :TBevelCut;
   FBevelKind          :TBevelKind;
   FBevelWidth         :TBevelWidth;
   FBorderWidth        :TBorderWidth;
   FPadding            :TPadding;
   FBrush              :TBrush;
   FDockClients        :TList;
   FDockManager        :IDockManager;
   FImeMode            :TImeMode;
   FImeName            :TImeName;
   FParentWindow       :HWND;
   FTabList            :TList;
   FTipMode            :TTipMode;
   FControls           :TList;
   FWinControls        :TList;
   FTabOrder           :Integer;
   FTabStop            :Boolean;
   FTIPIntf            :IInterface;
   FCtl3D              :Boolean;
   FShowing            :Boolean;
   FUseDockManager     :Boolean;
   FDockSite           :Boolean;
   FParentCtl3D        :Boolean;
   FParentDoubleBuffered:Boolean;
   FPerformingShowingChanged:Boolean;
   FOnDockDrop         :TDockDropEvent;
   FOnDockOver         :TDockOverEvent;
   FOnEnter            :TNotifyEvent;
   FOnExit             :TNotifyEvent;
   FOnGetSiteInfo      :TGetSiteInfoEvent;
   FOnKeyDown          :TKeyEvent;
   FOnKeyPress         :TKeyPressEvent;
   FOnKeyUp            :TKeyEvent;
   FOnUnDock           :TUnDockEvent;
   FOnAlignInsertBefore:TAlignInsertBeforeEvent;
   FOnAlignPosition    :TAlignPositionEvent;
   FMouseInClient      :Boolean;
   FMouseControl       :TControl;
   FTouchControl       :TControl;
   FDefWndProc         :Pointer;
   FHandle             :HWND;
   FObjectInstance     :Pointer;
   FParent             :TWinControl;
   FWindowProc         :TWndMethod;
   FLeft               :Integer;
   FTop                :Integer;
   FWidth              :Integer;
   FHeight             :Integer;
   FControlStyle       :TControlStyle;
   FControlState       :TControlState;
   FDesktopFont        :Boolean;
   FVisible            :Boolean;
   FEnabled            :Boolean;
   FParentFont         :Boolean;
   FParentColor        :Boolean;
   FAlign              :TAlign;
   FAutoSize           :Boolean;
   FDragMode           :TDragMode;
   FIsControl          :Boolean;
   FBiDiMode           :TBiDiMode;
   FParentBiDiMode     :Boolean;
   FAnchors            :TAnchors;
   FFont               :TFont;
   FActionLink         :TControlActionLink;
   FColor              :TColor;
   FConstraints        :TSizeConstraints;
   FMargins            :TMargins;
   FCursor             :TCursor;
   FDragCursor         :TCursor;
   FPopupMenu          :TPopupMenu;
   FHint               :string;
   FFontHeight         :Integer;
   FScalingFlags       :TScalingFlags;
   FShowHint           :Boolean;
   FParentShowHint     :Boolean;
   FDragKind           :TDragKind;
   FDockOrientation    :TDockOrientation;
   FHostDockSite       :TWinControl;
   FWheelAccumulator   :Integer;
   FUndockWidth        :Integer;
   FUndockHeight       :Integer;
   FLRDockWidth        :Integer;
   FTBDockHeight       :Integer;
   FFloatingDockSiteClass:TWinControlClass;
   FTouchManager       :TTouchManager;
   FOnCanResize        :TCanResizeEvent;
   FOnConstrainedResize:TConstrainedResizeEvent;
   FOnMouseDown        :TMouseEvent;
   FOnMouseMove        :TMouseMoveEvent;
   FOnMouseUp          :TMouseEvent;
   FOnDragDrop         :TDragDropEvent;
   FOnDragOver         :TDragOverEvent;
   FOnResize           :TNotifyEvent;
   FOnStartDock        :TStartDockEvent;
   FOnEndDock          :TEndDragEvent;
   FOnStartDrag        :TStartDragEvent;
   FOnEndDrag          :TEndDragEvent;
   FOnClick            :TNotifyEvent;
   FOnDblClick         :TNotifyEvent;
   FOnContextPopup     :TContextPopupEvent;
   FOnMouseActivate    :TMouseActivateEvent;
   FOnMouseLeave       :TNotifyEvent;
   FOnMouseEnter       :TNotifyEvent;
   FOnMouseWheel       :TMouseWheelEvent;
   FOnMouseWheelDown   :TMouseWheelUpDownEvent;
   FOnMouseWheelUp     :TMouseWheelUpDownEvent;
   FOnGesture          :TGestureEvent;
   FHelpType           :THelpType;
   FHelpKeyword        :string;
   FHelpContext        :THelpContext;
   FCustomHint         :TCustomHint;
   FParentCustomHint   :Boolean;
   FText               :PWideChar;
   FStyleElements      :TStyleElements;
   FOwner              :TComponent;
   FName               :TComponentName;
   FTag                :NativeInt;
   FComponents         :TList<System.Classes.TComponent>;
   FFreeNotifies       :TList<System.Classes.TComponent>;
   FDesignInfo         :Integer;
   FComponentState     :TComponentState;
   FVCLComObject       :Pointer;
   FObservers          :TObservers;
   FSortedComponents   :TList<System.Classes.TComponent>;
   function GetClosedItems(Index: Integer): string;
   function GetClosedProjects(Index: Integer): string;
   function GetClosedFiles(Index: Integer): string;
   function GetPersonalities(Index: Integer): string;
   function GetDockClients(Index: Integer): TControl;
   function GetControl(Index: Integer): TControl;
   function GetComponent(AIndex: Integer): TComponent;
  protected
   FMaxAlign           :TAlign;
   FLastLoadedBounds   :TRect;
   FDockingTouched     :Boolean;
   FFormState          :TFormState;
   FDoubleBuffered     :Boolean;
   FInImeComposition   :Boolean;
   FDesignSize         :TPoint;
   FAnchorMove         :Boolean;
   FAnchorRules        :TPoint;
   FAnchorOrigin       :TPoint;
   FOriginalParentSize :TPoint;
   FExplicitLeft       :Integer;
   FExplicitTop        :Integer;
   FExplicitWidth      :Integer;
   FExplicitHeight     :Integer;
   FReserved           :Pointer;
   FComponentStyle     :TComponentStyle;
   function get_MDIChildren(I: Integer): TForm;
   function get_MDIChildren(I: Integer): TForm;
  public
   BuildTimeStr        :string;
   BuildState          :string;
   DesktopSaved        :Boolean;
   WindowsHidden       :Boolean;
   ExeDir              :string;
   AppStateID          :string;
   constructor Create(AOwner: TComponent);
   procedure MouseWheelHandler(var Message: TMessage);
   procedure WMMouseWheel(var Message: TMessage);
   procedure WMGetMinMaxInfo(var Message: TWMGetMinMaxInfo);
   procedure WMSize(var Message: TWMSize);
   function TerminateDebugging: Boolean;
   function CloseProjectGroup: Boolean;
   function CanCloseProjectGroup: Boolean;
   procedure DestroyProjectGroup;
   function CreateProjectGroup(const AProjectGroupName: string; const AFileSystem: string; Existing: Boolean): Boolean;
   procedure FileOpenDialog(const AFileName: string; const Path: string);
   function IsEditorOpen: Boolean;
   function CanCreatePackage: Boolean;
   procedure FreeCompLib;
   function OpenFile(const AFileName: string; MustExist: Boolean; Show: Boolean): TDocModule;
   procedure SourceModified(const FileName: string);
   function Compile(CompileMode: TCompileMode; Wait: Boolean): Boolean;
   function CompileAll(CompileMode: TCompileMode; Wait: Boolean): Boolean;
   procedure HideWindows;
   procedure ShowWindows;
   procedure ProcessStarted(Sender: TObject; const Process: IOTAProcess);
   procedure ProcessStopped(Sender: TObject; const Process: IOTAProcess);
   procedure ProcessStopping(Sender: TObject; const Process: IOTAProcess);
   procedure ProcessFaulted(Sender: TObject; const Process: IOTAProcess);
   procedure ProcessTerminated(Sender: TObject; const Process: IOTAProcess);
   procedure ProcessException(Sender: TObject; const Process: IOTAProcess);
   procedure DebuggerFocusIDE(Sender: TObject);
   procedure CurrentDebuggerChanged(Sender: TObject);
   procedure CurrentProcessChanged(Sender: TObject; const Process: IOTAProcess);
   procedure CurrentThreadChanged(Sender: TObject; const Thread: IOTAThread);
   procedure GetDebugSourcepath(Sender: TObject; var DebugSourcePath: string);
   procedure GetDebugSearchpath(Sender: TObject; var DebugSearchPath: string);
   procedure CheckFileExists(Sender: TObject; const FileName: string; var Exists: Boolean);
   function FormEdit(Action: TEditAction): Boolean;
   procedure DoEditAction(Action: TEditAction; Message: Integer);
   function GetCurrentEditState: TEditState;
   function IsDesignerActive: Boolean;
   procedure ResetSourceModified;
   procedure SetAppTitle(const Str: string);
   procedure RunDebugger(const TDWName: TFileName);
   procedure UpdateModuleDisplay;
   function GetShowExceptionText(E: Exception): string;
   class procedure RaiseAccexxViolation(Param: Integer);
   class procedure Raise1AccexxViolation(Param: Integer);
   class procedure Raise2AccexxViolation(Param: Integer);
   class procedure Raise3AccexxViolation(Param: Integer);
   class procedure Raise4AccexxViolation(Param: Integer);
   class procedure DeadmanTrigger(Param: Integer);
   procedure DoGoombaCheck;
   procedure UpdateMenuBarButtons(Menu: TMenu);
   procedure DesktopMenuItemClick(Sender: TObject);
   procedure DesktopSelectionChanged(Sender: TObject);
   procedure LoadWindowState(Desktop: TCustomIniFile);
   procedure SaveWindowState(Desktop: TCustomIniFile; isProject: Boolean);
   procedure LoadDockState(Desktop: TCustomIniFile);
   procedure ItsToolTimeBaby(const S: string);
   procedure GlueSolvent(var B: Boolean);
   procedure RevenueGenerator;
   procedure PrintMoreMoney;
   procedure Dasvidaniya(const Timeout: Integer);
   procedure RunAwayFast;
   function GetIDEProperty(const PropType: Integer): OleVariant;
   constructor Create(AOwner: TComponent);
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   function EditAction(Action: TEditAction): Boolean;
   function GetEditState: TEditState;
   procedure SaveWindowState(Desktop: TCustomIniFile; isProject: Boolean);
   procedure LoadWindowState(Desktop: TCustomIniFile);
   procedure LockUpdates;
   procedure Repaint;
   function ShouldAutoHide: Boolean;
   procedure SaveDockClients(DeskTop: TCustomIniFile; const IsProject: Boolean; const Section: string; DockSite: TWinControl);
   procedure SaveDockStream(DeskTop: TCustomIniFile; const Section: string; DockSite: TWinControl);
   function LoadDockClients(DeskTop: TCustomIniFile; const Section: string; DockSite: TWinControl): Boolean;
   procedure LoadDockStream(DeskTop: TCustomIniFile; const Section: string; DockSite: TWinControl);
   procedure ArrangeIcons;
   procedure Cascade;
   procedure Next;
   procedure Previous;
   procedure Tile;
   constructor Create(AOwner: TComponent);
   constructor CreateNew(AOwner: TComponent; Dummy: Integer);
   class destructor Destroy;
   procedure Close;
   function CloseQuery: Boolean;
   procedure DefaultHandler(var Message);
   procedure DefocusControl(Control: TWinControl; Removing: Boolean);
   procedure Dock(NewDockSite: TWinControl; ARect: TRect);
   procedure FocusControl(Control: TWinControl);
   procedure GetChildren(Proc: TGetChildProc = procedure(Child: TComponent) of object; Root: TComponent);
   function GetFormImage: TBitmap;
   procedure Hide;
   function IsShortCut(var Message: TWMKey): Boolean;
   procedure MakeFullyVisible(AMonitor: TMonitor);
   procedure MouseWheelHandler(var Message: TMessage);
   procedure Print;
   procedure RecreateAsPopup(AWindowHandle: HWND);
   procedure Release;
   procedure SendCancelMode(Sender: TControl);
   procedure SetFocus;
   function SetFocusedControl(Control: TWinControl): Boolean;
   procedure Show;
   function ShowModal: Integer;
   function WantChildKey(Child: TControl; var Message: TMessage): Boolean;
   procedure set_PopupParent(Value: TCustomForm);
   procedure AfterConstruction;
   procedure BeforeDestruction;
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure DisableAutoRange;
   procedure EnableAutoRange;
   procedure ScrollInView(AControl: TControl);
   constructor Create(AOwner: TComponent);
   constructor CreateParented(ParentWindow: HWND);
   class function CreateParentedControl(ParentWindow: HWND): TWinControl;
   class destructor Destroy;
   procedure Broadcast(var Message);
   function CanFocus: Boolean;
   function ContainsControl(Control: TControl): Boolean;
   function ControlAtPos(const Pos: TPoint; AllowDisabled: Boolean; AllowWinControls: Boolean; AllLevels: Boolean): TControl;
   procedure DefaultHandler(var Message);
   procedure DisableAlign;
   procedure DockDrop(Source: TDragDockObject; X: Integer; Y: Integer);
   procedure EnableAlign;
   function FindChildControl(const ControlName: string): TControl;
   procedure FlipChildren(AllLevels: Boolean);
   function Focused: Boolean;
   procedure GetChildren(Proc: TGetChildProc = procedure(Child: TComponent) of object; Root: TComponent);
   procedure GetTabControlList(List: TList);
   procedure GetTabOrderList(List: TList);
   function HandleAllocated: Boolean;
   procedure HandleNeeded;
   procedure InsertControl(AControl: TControl);
   procedure Invalidate;
   procedure PaintTo(DC: HDC; X: Integer; Y: Integer);
   procedure PaintTo(Canvas: TCanvas; X: Integer; Y: Integer);
   function PreProcessMessage(var Msg: tagMSG): Boolean;
   procedure RemoveControl(AControl: TControl);
   procedure Realign;
   procedure Repaint;
   procedure ScaleBy(M: Integer; D: Integer);
   procedure ScrollBy(DeltaX: Integer; DeltaY: Integer);
   procedure SetBounds(ALeft: Integer; ATop: Integer; AWidth: Integer; AHeight: Integer);
   procedure SetDesignVisible(Value: Boolean);
   procedure SetFocus;
   procedure Update;
   procedure UpdateControlState;
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure BeginDrag(Immediate: Boolean; Threshold: Integer);
   procedure BringToFront;
   function ClientToScreen(const Point: TPoint): TPoint;
   function ClientToParent(const Point: TPoint; AParent: TWinControl): TPoint;
   procedure Dock(NewDockSite: TWinControl; ARect: TRect);
   function Dragging: Boolean;
   procedure DragDrop(Source: TObject; X: Integer; Y: Integer);
   function DrawTextBiDiModeFlags(Flags: Integer): Integer;
   function DrawTextBiDiModeFlagsReadingOnly: Integer;
   procedure EndDrag(Drop: Boolean);
   function GetControlsAlignment: TAlignment;
   function GetParentComponent: TComponent;
   function HasParent: Boolean;
   procedure Hide;
   procedure InitiateAction;
   procedure Invalidate;
   procedure MouseWheelHandler(var Message: TMessage);
   function IsRightToLeft: Boolean;
   function ManualDock(NewDockSite: TWinControl; DropControl: TControl; ControlSide: TAlign): Boolean;
   function ManualFloat(ScreenPos: TRect): Boolean;
   function Perform(Msg: Cardinal; WParam: NativeUInt; LParam: NativeInt): NativeInt;
   procedure Refresh;
   procedure Repaint;
   function ReplaceDockedControl(Control: TControl; NewDockSite: TWinControl; DropControl: TControl; ControlSide: TAlign): Boolean;
   function ScreenToClient(const Point: TPoint): TPoint;
   function ParentToClient(const Point: TPoint; AParent: TWinControl): TPoint;
   procedure SendToBack;
   procedure SetBounds(ALeft: Integer; ATop: Integer; AWidth: Integer; AHeight: Integer);
   procedure SetDesignVisible(Value: Boolean);
   procedure SetParentComponent(Value: TComponent);
   procedure Show;
   procedure Update;
   function UseRightToLeftAlignment: Boolean;
   function UseRightToLeftReading: Boolean;
   function UseRightToLeftScrollBar: Boolean;
   procedure DefaultHandler(var Message);
   function GetTextBuf(Buffer: PWideChar; BufSize: Integer): Integer;
   function GetTextLen: Integer;
   function Perform(Msg: Cardinal; WParam: NativeUInt; LParam: PWideChar): NativeInt;
   function Perform(Msg: Cardinal; WParam: NativeUInt; var LParam: TRect): NativeInt;
   procedure SetTextBuf(Buffer: PWideChar);
   constructor Create(AOwner: TComponent);
   class destructor Destroy;
   procedure BeforeDestruction;
   procedure DestroyComponents;
   procedure Destroying;
   function ExecuteAction(Action: TBasicAction): Boolean;
   function FindComponent(const AName: string): TComponent;
   procedure FreeNotification(AComponent: TComponent);
   procedure RemoveFreeNotification(AComponent: TComponent);
   procedure FreeOnRelease;
   function GetEnumerator: TComponentEnumerator;
   function GetParentComponent: TComponent;
   function GetNamePath: string;
   function HasParent: Boolean;
   procedure InsertComponent(const AComponent: TComponent);
   procedure RemoveComponent(const AComponent: TComponent);
   procedure SetSubComponent(IsSubComponent: Boolean);
   function SafeCallException(ExceptObject: TObject; ExceptAddr: Pointer): HRESULT;
   function UpdateAction(Action: TBasicAction): Boolean;
   function IsImplementorOf(const I: IInterface): Boolean;
   function ReferenceInterface(const I: IInterface; Operation: TOperation): Boolean;
   class destructor Destroy;
   procedure Assign(Source: TPersistent);
   function GetNamePath: string;
   constructor Create;
   procedure Free;
   procedure DisposeOf;
   class function InitInstance(Instance: Pointer): TObject;
   procedure CleanupInstance;
   function ClassType: TClass;
   class function ClassName: string;
   class function ClassNameIs(const Name: string): Boolean;
   class function ClassParent: TClass;
   class function ClassInfo: Pointer;
   class function InstanceSize: Integer;
   class function InheritsFrom(AClass: TClass): Boolean;
   class function MethodAddress(const Name: ShortString): Pointer;
   class function MethodAddress(const Name: string): Pointer;
   class function MethodName(Address: Pointer): string;
   class function QualifiedClassName: string;
   function FieldAddress(const Name: ShortString): Pointer;
   function FieldAddress(const Name: string): Pointer;
   function GetInterface(const IID: TGUID; out Obj): Boolean;
   class function GetInterfaceEntry(const IID: TGUID): PInterfaceEntry;
   class function GetInterfaceTable: PInterfaceTable;
   class function UnitName: string;
   class function UnitScope: string;
   function Equals(Obj: TObject): Boolean;
   function GetHashCode: Integer;
   function ToString: string;
   function SafeCallException(ExceptObject: TObject; ExceptAddr: Pointer): HRESULT;
   procedure AfterConstruction;
   procedure BeforeDestruction;
   procedure Dispatch(var Message);
   procedure DefaultHandler(var Message);
   class function NewInstance: TObject;
   procedure FreeInstance;
   class destructor Destroy;
   property Toolbars: TToolbarArray;
   property ClosedItemsCount: Integer;
   property ClosedProjectsCount: Integer;
   property ClosedFilesCount: Integer;
   property CurrentPersonality: string;
   property PersonalityCount: Integer;
   property DeskSection: string;
   property AutoSave: Boolean;
   property LoadedFromDesktop: Boolean;
   property ActiveMDIChild: TForm;
   property ClientHandle: HWND;
   property DockManager: IDockManager;
   property MDIChildCount: Integer;
   property TileMode: TTileMode;
   property Active: Boolean;
   property ActiveControl: TWinControl;
   property Action: TBasicAction;
   property ActiveOleControl: TWinControl;
   property BorderStyle: TFormBorderStyle;
   property Canvas: TCanvas;
   property Caption: TCaption;
   property Color: TColor;
   property Designer: IDesignerHook;
   property DropTarget: Boolean;
   property Font: TFont;
   property FormState: TFormState;
   property GlassFrame: TGlassFrame;
   property HelpFile: string;
   property KeyPreview: Boolean;
   property Menu: TMainMenu;
   property ModalResult: TModalResult;
   property Monitor: TMonitor;
   property OleFormObject: IOleForm;
   property PopupMode: TPopupMode;
   property ScreenSnap: Boolean;
   property SnapBuffer: Integer;
   property WindowState: TWindowState;
   property PopupParent: TCustomForm;
   property DockClientCount: Integer;
   property DockSite: Boolean;
   property DockManager: IDockManager;
   property DoubleBuffered: Boolean;
   property AlignDisabled: Boolean;
   property MouseInClient: Boolean;
   property VisibleDockClientCount: Integer;
   property Brush: TBrush;
   property ControlCount: Integer;
   property Handle: HWND;
   property Padding: TPadding;
   property ParentDoubleBuffered: Boolean;
   property ParentWindow: HWND;
   property Showing: Boolean;
   property TabOrder: TTabOrder;
   property TabStop: Boolean;
   property UseDockManager: Boolean;
   property Enabled: Boolean;
   property Action: TBasicAction;
   property Align: TAlign;
   property Anchors: TAnchors;
   property BiDiMode: TBiDiMode;
   property BoundsRect: TRect;
   property ClientHeight: Integer;
   property ClientOrigin: TPoint;
   property ClientRect: TRect;
   property ClientWidth: Integer;
   property Constraints: TSizeConstraints;
   property ControlState: TControlState;
   property ControlStyle: TControlStyle;
   property DockOrientation: TDockOrientation;
   property ExplicitLeft: Integer;
   property ExplicitTop: Integer;
   property ExplicitWidth: Integer;
   property ExplicitHeight: Integer;
   property Floating: Boolean;
   property FloatingDockSiteClass: TWinControlClass;
   property HostDockSite: TWinControl;
   property LRDockWidth: Integer;
   property ShowHint: Boolean;
   property TBDockHeight: Integer;
   property Touch: TTouchManager;
   property UndockHeight: Integer;
   property UndockWidth: Integer;
   property Visible: Boolean;
   property WindowProc: TWndMethod;
   property Parent: TWinControl;
   property StyleElements: TStyleElements;
   property OnGesture: TGestureEvent;
   property ComObject: IInterface;
   property ComponentCount: Integer;
   property ComponentIndex: Integer;
   property ComponentState: TComponentState;
   property ComponentStyle: TComponentStyle;
   property DesignInfo: Integer;
   property Owner: TComponent;
   property VCLComObject: Pointer;
   property Observers: TObservers;
  published
   MainMenu1           :TMainMenu;
   FileMenu            :TMenuItem;
   FileNewItem         :TMenuItem;
   FileOpenItem        :TMenuItem;
   FileOpenProjectItem :TMenuItem;
   FileClosedFilesItem :TMenuItem;
   FileSaveSeparater   :TMenuItem;
   FileSaveItem        :TMenuItem;
   FileSaveAsItem      :TMenuItem;
   FileSaveProjectAs   :TMenuItem;
   FileSaveAllItem     :TMenuItem;
   FileCloseItem       :TMenuItem;
   FileCloseAllItem    :TMenuItem;
   FilePrintItem       :TMenuItem;
   FileExitItem        :TMenuItem;
   EditMenu            :TMenuItem;
   EditUndoItem        :TMenuItem;
   EditRedoItem        :TMenuItem;
   EditCutItem         :TMenuItem;
   EditCopyItem        :TMenuItem;
   EditPasteItem       :TMenuItem;
   EditDeleteItem      :TMenuItem;
   EditSelectAll       :TMenuItem;
   EditAlignGridItem   :TMenuItem;
   EditFrontItem       :TMenuItem;
   EditBackItem        :TMenuItem;
   EditAlignItem       :TMenuItem;
   EditSizeItem        :TMenuItem;
   EditScaleItem       :TMenuItem;
   EditTabOrderItem    :TMenuItem;
   EditCreationOrderItem:TMenuItem;
   EditFlipChildrenItem:TMenuItem;
   EditFlipChildrenAllItem:TMenuItem;
   EditFlipChildrenSelectedItem:TMenuItem;
   EditLockControlsItem:TMenuItem;
   SearchMenu          :TMenuItem;
   SearchFindItem      :TMenuItem;
   SearchFileFindItem  :TMenuItem;
   SearchReplaceItem   :TMenuItem;
   SearchAgainItem     :TMenuItem;
   SearchIncrementalItem:TMenuItem;
   SearchGoToItem      :TMenuItem;
   ViewsMenu           :TMenuItem;
   ViewPrjSourceItem   :TMenuItem;
   ViewNewEditorItem   :TMenuItem;
   ProjectMenu         :TMenuItem;
   ProjectAddItem      :TMenuItem;
   ProjectRemoveItem   :TMenuItem;
   ProjectAddRepositoryItem:TMenuItem;
   ProjectAddNewProjectItem:TMenuItem;
   ProjectAddExistingProjectItem:TMenuItem;
   ProjectCompileItem  :TMenuItem;
   ProjectBuildItem    :TMenuItem;
   ProjectInformationItem:TMenuItem;
   ProjectCompileAllItem:TMenuItem;
   ProjectBuildAllItem :TMenuItem;
   ProjectSeparator2   :TMenuItem;
   ProjectDependenciesItem:TMenuItem;
   ProjectOptionsItem  :TMenuItem;
   RunMenu             :TMenuItem;
   RunRunItem          :TMenuItem;
   RunParametersItem   :TMenuItem;
   RunParametersSeparator:TMenuItem;
   RunStepOverItem     :TMenuItem;
   RunTraceIntoItem    :TMenuItem;
   RunTraceToSourceItem:TMenuItem;
   RunGotoCursorItem   :TMenuItem;
   RunShowCSIPItem     :TMenuItem;
   RunPauseItem        :TMenuItem;
   RunResetItem        :TMenuItem;
   RunDetachItem       :TMenuItem;
   RunInspectSeparator :TMenuItem;
   ComponentMenu       :TMenuItem;
   ToolsMenu           :TMenuItem;
   ToolsOptionsItem    :TMenuItem;
   ToolsGalleryItem    :TMenuItem;
   ToolsTemplateLibrariesItem:TMenuItem;
   ToolsToolsItem      :TMenuItem;
   HelpMenu            :TMenuItem;
   HelpContentsItem    :TMenuItem;
   HelpEmbarcaderoPage :TMenuItem;
   HelpCommunityPage   :TMenuItem;
   HelpProgGuideSeparater:TMenuItem;
   OpenFileDialog      :TOpenDialog;
   SaveFileDialog      :TSaveDialog;
   PrinterSetupDialog  :TPrinterSetupDialog;
   N1                  :TMenuItem;
   N2                  :TMenuItem;
   StandardToolBar     :TDockToolBar;
   ImageList1          :TImageList;
   ActionList1         :TActionManager;
   FileNewCommand      :TAction;
   FileOpenCommand     :TControlAction;
   FileOpenProjectCommand:TAction;
   FileSaveCommand     :TAction;
   FileSaveAsCommand   :TAction;
   FileSaveProjectAsCommand:TAction;
   FileSaveAllCommand  :TAction;
   FileCloseCommand    :TAction;
   FileCloseAllCommand :TAction;
   FilePrintCommand    :TAction;
   FileExitCommand     :TAction;
   EditUndoCommand     :TAction;
   EditRedoCommand     :TAction;
   EditCutCommand      :TAction;
   EditCopyCommand     :TAction;
   EditPasteCommand    :TAction;
   EditDeleteCommand   :TAction;
   EditSelectAllCommand:TAction;
   EditTabOrderCommand :TAction;
   EditCreationOrderCommand:TAction;
   EditFlipChildrenAllCommand:TAction;
   EditFlipChildrenSelectedCommand:TAction;
   EditLockControlsCommand:TAction;
   SearchFindCommand   :TAction;
   SearchFileFindCommand:TAction;
   SearchReplaceCommand:TAction;
   SearchAgainCommand  :TAction;
   SearchIncrementalCommand:TAction;
   SearchGoToCommand   :TAction;
   ViewNewEditorCommand:TAction;
   ProjectAddCommand   :TAction;
   ProjectRemoveCommand:TAction;
   ProjectAddRepositoryCommand:TAction;
   ProjectAddNewProjectCommand:TAction;
   ProjectAddExistingProjectCommand:TAction;
   ProjectCompileCommand:TAction;
   ProjectBuildCommand :TAction;
   ProjectInformationCommand:TAction;
   ProjectCompileAllCommand:TAction;
   ProjectBuildAllCommand:TAction;
   ProjectDependenciesCommand:TAction;
   ProjectOptionsCommand:TAction;
   RunRunCommand       :TControlAction;
   RunParametersCommand:TAction;
   RunStepOverCommand  :TAction;
   RunTraceIntoCommand :TAction;
   RunTraceToSourceCommand:TAction;
   RunGotoCursorCommand:TAction;
   RunShowCSIPCommand  :TAction;
   RunPauseCommand     :TAction;
   RunResetCommand     :TAction;
   RunDetachCommand    :TAction;
   ToolsOptionsCommand :TAction;
   ToolsGalleryCommand :TAction;
   ToolsTemplateLibrariesCommand:TAction;
   ToolsToolsCommand   :TAction;
   HelpContentsCommand :TAction;
   HelpEmbarcaderoPageCommand:TAction;
   HelpCommunityPageCommand:TAction;
   ProjectViewSourceCommand:TAction;
   ToolButton1         :TToolButton;
   ToolButton2         :TToolButton;
   ToolButton4         :TToolButton;
   ToolButton5         :TToolButton;
   ToolButton6         :TToolButton;
   ToolButton7         :TToolButton;
   ToolButton21        :TToolButton;
   ToolbarsPopup       :TPopupActionBar;
   ViewToolbarsItem    :TMenuItem;
   ViewCustomizeCommand:TAction;
   Customize1          :TMenuItem;
   N5                  :TMenuItem;
   ControlBar1         :TControlBar;
   MenuBar             :TActionMainMenuBar;
   ToolbarActionList   :TActionList;
   ViewStandardCommand :TAction;
   ProcessMenu         :TPopupMenu;
   CommandButton2      :TToolButton;
   ClosedFilesPopup    :TPopupMenu;
   CustomToolBar       :TDockToolBar;
   DebugToolBar        :TDockToolBar;
   CommandButton1      :TToolButton;
   ToolButton3         :TToolButton;
   ToolButton13        :TToolButton;
   ToolButton15        :TToolButton;
   ToolButton16        :TToolButton;
   ToolButton8         :TToolButton;
   ToolButton14        :TToolButton;
   ViewCustomCommand   :TAction;
   ViewDebugCommand    :TAction;
   ProjectCompileSeparator:TMenuItem;
   Panel1              :TPanel;
   ViewDesktopsMenu    :TMenuItem;
   SaveDesktop1        :TMenuItem;
   DesktopToolBar      :TDockToolBar;
   cbDesktop           :TDesktopComboBox;
   ToolButton17        :TToolButton;
   ToolButton18        :TToolButton;
   ToolButton19        :TToolButton;
   ViewSaveDesktopCommand:TAction;
   ViewRuntimeDesktopCommand:TAction;
   SetDebugDesktop1    :TMenuItem;
   ViewDesktopCommand  :TAction;
   DeleteDesktop       :TMenuItem;
   ViewDeleteDesktopCommand:TAction;
   ApplicationEvents   :TApplicationEvents;
   New1                :TMenuItem;
   N4                  :TMenuItem;
   Docking1            :TMenuItem;
   Active1             :TMenuItem;
   AutoHide1           :TMenuItem;
   Alwaysontop1        :TMenuItem;
   DockArea1           :TMenuItem;
   Top1                :TMenuItem;
   Left1               :TMenuItem;
   Right1              :TMenuItem;
   Bottom1             :TMenuItem;
   Float1              :TMenuItem;
   Animation1          :TMenuItem;
   ProjectClearUnitCacheItem:TMenuItem;
   RunRunNoDebugCommand:TControlAction;
   RunRunNoDebugItem   :TMenuItem;
   DockBottomPanel     :TEditorDockPanel;
   actnDockEditWindow  :TAction;
   DockEditWindow1     :TMenuItem;
   actnCompDummy       :TAction;
   ComponentPaletteItem:TMenuItem;
   EditWindowSeparator :TMenuItem;
   actnCustomizeNew    :TAction;
   mnuNewActionSeparator:TMenuItem;
   mnuCustomize        :TMenuItem;
   NewItemsImageList   :TImageList;
   NewItemsActionList  :TActionList;
   mnuBetweenOtherandCustomize:TMenuItem;
   N3                  :TMenuItem;
   AlignLeftEdgesCommand:TAction;
   AlignRightEdgesCommand:TAction;
   AlignTopEdgesCommand:TAction;
   AlignBottomEdgesCommand:TAction;
   AlignHorizCentersCommand:TAction;
   AlignVertCentersCommand:TAction;
   AlignAlignToGridCommand:TAction;
   AlignBringToFrontCommand:TAction;
   AlignSendToBackCommand:TAction;
   AlignAlignCommand   :TAction;
   AlignSizeCommand    :TAction;
   AlignScaleCommand   :TAction;
   CenterVertCommand   :TAction;
   CenterHorizCommand  :TAction;
   SpaceHorizEqualCommand:TAction;
   SpaceVertEqualCommand:TAction;
   AlignToolbar        :TDockToolBar;
   IncHorizontalSpaceCommand:TAction;
   DecHorizontalSpaceCommand:TAction;
   DelHorizontalSpaceCommand:TAction;
   IncVerticalSpaceCommand:TAction;
   DecVerticalSpaceCommand:TAction;
   DelVerticalSpaceCommand:TAction;
   AlignMakeSameHeight :TAction;
   AlignMakeSameSize   :TAction;
   AlignMakeSameWidth  :TAction;
   AlignSizeToGrid     :TAction;
   ToolButton29        :TToolButton;
   ToolButton31        :TToolButton;
   ToolButton32        :TToolButton;
   ToolButton33        :TToolButton;
   SpacingToolbar      :TDockToolBar;
   ToolButton34        :TToolButton;
   ToolButton35        :TToolButton;
   ToolButton36        :TToolButton;
   ToolButton37        :TToolButton;
   ToolButton38        :TToolButton;
   ToolButton39        :TToolButton;
   ToolButton40        :TToolButton;
   ToolButton41        :TToolButton;
   ToolButton42        :TToolButton;
   PositionToolbar     :TDockToolBar;
   ToolButton24        :TToolButton;
   ToolButton25        :TToolButton;
   ToolButton30        :TToolButton;
   ToolButton43        :TToolButton;
   ToolButton44        :TToolButton;
   AlignSnapToGridCommand:TAction;
   ToolButton45        :TToolButton;
   ToolButton46        :TToolButton;
   ProjectDefaultOptionsCommand:TAction;
   ProjectDefaultOptionsItem:TMenuItem;
   PersonalityToolBar  :TDockToolBar;
   PersonalityToolbutton:TToolButton;
   CheckoutLicenseCommand:TAction;
   CheckinLicenseCommand:TAction;
   N6                  :TMenuItem;
   CheckoutLicenseItem :TMenuItem;
   CheckinLicenseItem  :TMenuItem;
   HelpSupportPageCommand:TAction;
   HelpDeveloperSupportPage:TMenuItem;
   ProjectCleanCommand :TAction;
   ProjectCleanItem    :TMenuItem;
   ComponentAction     :TAction;
   ReopenPropertiesItem:TMenuItem;
   N7                  :TMenuItem;
   ProjectStopBuildCommand:TAction;
   ProjectStopBuildItem:TMenuItem;
   FileOpenFromRepository:TAction;
   OpenFromRepository1 :TMenuItem;
   ToolButton47        :TToolButton;
   HelpDocRadStudioDocWikiCommand:TAction;
   HelpDocWindowsPlatformSDKCommand:TAction;
   HelpDocOSXDeveloperLibraryCommand:TAction;
   N8                  :TMenuItem;
   HelpDocRADStudioDocwiki:TMenuItem;
   HelpDocWindowsPlatformSDKLibrary:TMenuItem;
   HelpDocMacOSXDeveloperLibrary:TMenuItem;
   procedure ControlBar1BandPaint(Sender: TObject; Control: TControl; Canvas: TCanvas; var ARect: TRect; var Options: TBandPaintOptions);
   procedure CheckinLicenseCommandExecute(Sender: TObject);
   procedure CheckoutLicenseCommandUpdate(Sender: TObject);
   procedure CheckoutLicenseCommandExecute(Sender: TObject);
   procedure FormCreate(Sender: TObject);
   procedure FormDestroy(Sender: TObject);
   procedure WindowCloseQuery(Sender: TObject; var CanClose: Boolean);
   procedure FileNew(Sender: TObject);
   procedure FileNewInheritedForm(Sender: TObject);
   procedure FileNewLibrary(Sender: TObject);
   procedure FileNewTextFile(Sender: TObject);
   procedure FileOpen(Sender: TObject);
   procedure FileSave(Sender: TObject);
   procedure FileSaveAs(Sender: TObject);
   procedure FileSaveAll(Sender: TObject);
   procedure FileClose(Sender: TObject);
   procedure FileCloseAll(Sender: TObject);
   procedure FilePrint(Sender: TObject);
   procedure FileSend(Sender: TObject);
   procedure FileExit(Sender: TObject);
   procedure FileNewConsoleApp(Sender: TObject);
   procedure UpdateCaptionNow(const NewState: string);
   procedure EditUndo(Sender: TObject);
   procedure EditRedo(Sender: TObject);
   procedure EditCut(Sender: TObject);
   procedure EditCopy(Sender: TObject);
   procedure EditPaste(Sender: TObject);
   procedure EditDelete(Sender: TObject);
   procedure EditSelectAllClick(Sender: TObject);
   procedure EditLockControls(Sender: TObject);
   procedure EditAlign(Sender: TObject);
   procedure EditSize(Sender: TObject);
   procedure EditScale(Sender: TObject);
   procedure EditTabOrder(Sender: TObject);
   procedure EditCreationOrder(Sender: TObject);
   procedure EditFlipChildrenAll(Sender: TObject);
   procedure EditFlipChildrenSelected(Sender: TObject);
   procedure SearchFind(Sender: TObject);
   procedure SearchReplace(Sender: TObject);
   procedure SearchSearchAgain(Sender: TObject);
   procedure SearchIncrementalClick(Sender: TObject);
   procedure SearchGoToItemClick(Sender: TObject);
   procedure ViewPrjSourceItemClick(Sender: TObject);
   procedure ViewWorkspaceSourceItemClick(Sender: TObject);
   procedure ViewNewEditor(Sender: TObject);
   procedure ProjectCommandsUpdate(Sender: TObject);
   procedure ProjectAddFile(Sender: TObject);
   procedure ProjectRemoveFile(Sender: TObject);
   procedure ProjectAddRepository(Sender: TObject);
   procedure ProjectMake(Sender: TObject);
   procedure ProjectBuild(Sender: TObject);
   procedure ProjectClean(Sender: TObject);
   procedure ProjectInformation(Sender: TObject);
   procedure ProjectOpen(Sender: TObject);
   procedure ProjectSave(Sender: TObject);
   procedure ProjectSaveAs(Sender: TObject);
   procedure RunCommandsUpdate(Sender: TObject);
   procedure RunRun(Sender: TObject);
   procedure RunParametersItemClick(Sender: TObject);
   procedure RunStepInto(Sender: TObject);
   procedure RunStepOver(Sender: TObject);
   procedure RunTraceToSource(Sender: TObject);
   procedure RunGotoCursor(Sender: TObject);
   procedure RunShowCSIPItemClick(Sender: TObject);
   procedure RunPause(Sender: TObject);
   procedure ProgramReset(Sender: TObject);
   procedure ProgramDetach(Sender: TObject);
   procedure RunProcessSelected(Sender: TObject);
   procedure ProjectOptions(Sender: TObject);
   procedure ToolsOptions(Sender: TObject);
   procedure ToolsGallery(Sender: TObject);
   procedure ToolsTemplateLibraries(Sender: TObject);
   procedure ToolsTools(Sender: TObject);
   procedure HelpCommandsUpdate(Sender: TObject);
   procedure HelpContents(Sender: TObject);
   procedure HelpDelphiContents(Sender: TObject);
   procedure HelpCppContents(Sender: TObject);
   procedure ExecuteUserTool(Sender: TObject);
   procedure ArrangeMainWindow;
   procedure ToggleSpeedHints(Sender: TObject);
   procedure NextMessageClick(Sender: TObject);
   procedure PrevMessageClick(Sender: TObject);
   procedure SearchFileFind(Sender: TObject);
   procedure HelpEmbarcaderoPageCommandExecute(Sender: TObject);
   procedure ProjectCompileAll(Sender: TObject);
   procedure ProjectBuildAll(Sender: TObject);
   procedure ProjectCreatetarget(Sender: TObject);
   procedure ProjectOpenTarget(Sender: TObject);
   procedure ViewStandardCommandExecute(Sender: TObject);
   procedure ViewStandardCommandUpdate(Sender: TObject);
   procedure FormConstrainedResize(Sender: TObject; var MinWidth: Integer; var MinHeight: Integer; var MaxWidth: Integer; var MaxHeight: Integer);
   procedure FileSaveActionUpdate(Sender: TObject);
   procedure FileSaveAsActionUpdate(Sender: TObject);
   procedure FileSaveProjectAsActionUpdate(Sender: TObject);
   procedure FileSaveAllActionUpdate(Sender: TObject);
   procedure FileCloseActionUpdate(Sender: TObject);
   procedure FileCloseAllActionUpdate(Sender: TObject);
   procedure EditUndoCommandUpdate(Sender: TObject);
   procedure EditRedoCommandUpdate(Sender: TObject);
   procedure EditCutCommandUpdate(Sender: TObject);
   procedure EditCopyCommandUpdate(Sender: TObject);
   procedure EditPasteCommandUpdate(Sender: TObject);
   procedure EditDeleteCommandUpdate(Sender: TObject);
   procedure EditSelectAllCommandUpdate(Sender: TObject);
   procedure EditCommandUpdate(Sender: TObject);
   procedure SearchCommandUpdate(Sender: TObject);
   procedure SearchFileFindCommandUpdate(Sender: TObject);
   procedure ViewNewEditorCommandUpdate(Sender: TObject);
   procedure ViewPrjMgrCommandUpdate(Sender: TObject);
   procedure EditMenuClick(Sender: TObject);
   procedure ControlBar1BandInfo(Sender: TObject; Control: TControl; var Insets: TRect; var PreferredSize: Integer; var RowCount: Integer);
   procedure FormShortCut(var Msg: TWMKey; var Handled: Boolean);
   procedure MainMenu1Change(Sender: TObject; Source: TMenuItem; Rebuild: Boolean);
   procedure ControlBar1GetSiteInfo(Sender: TObject; DockClient: TControl; var InfluenceRect: TRect; MousePos: TPoint; var CanDock: Boolean);
   procedure FormClose(Sender: TObject; var Action: TCloseAction);
   procedure ProcessMenuPopup(Sender: TObject);
   procedure FilePrintCommandUpdate(Sender: TObject);
   procedure ViewToolbarsMenuClick(Sender: TObject);
   procedure ToolbarsPopupPopup(Sender: TObject);
   procedure ViewCustomizeCommandExecute(Sender: TObject);
   procedure ClosedFilesPopupPopup(Sender: TObject);
   procedure ControlBar1BandDrag(Sender: TObject; Control: TControl; var Drag: Boolean);
   procedure ViewDebugCommandExecute(Sender: TObject);
   procedure ViewDebugCommandUpdate(Sender: TObject);
   procedure ViewCustomCommandExecute(Sender: TObject);
   procedure ViewCustomCommandUpdate(Sender: TObject);
   procedure ToolBarStartDock(Sender: TObject; var DragObject: TDragDockObject);
   procedure ToolBarEndDock(Sender: TObject; Target: TObject; X: Integer; Y: Integer);
   procedure ControlBar1DockOver(Sender: TObject; Source: TDragDockObject; X: Integer; Y: Integer; State: TDragState; var Accept: Boolean);
   procedure cbDesktopDropDown(Sender: TObject);
   procedure ViewDesktopsMenuClick(Sender: TObject);
   procedure ViewSaveDesktopCommandExecute(Sender: TObject);
   procedure ViewRuntimeDesktopCommandExecute(Sender: TObject);
   procedure ViewDesktopCommandExecute(Sender: TObject);
   procedure ViewDesktopCommandUpdate(Sender: TObject);
   procedure ViewDeleteDesktopCommandExecute(Sender: TObject);
   procedure ViewRuntimeDesktopCommandUpdate(Sender: TObject);
   procedure cbDesktopKeyPress(Sender: TObject; var Key: Char);
   procedure cbDesktopClick(Sender: TObject);
   procedure MenuBarCustomDrawButton(Sender: TToolBar; Button: TToolButton; State: TCustomDrawState; var DefaultDraw: Boolean);
   procedure ApplicationActivated(Sender: TObject);
   procedure Idle(Sender: TObject; var Done: Boolean);
   procedure ShowException(Sender: TObject; E: Exception);
   procedure FormActivate(Sender: TObject);
   procedure FileNewCommandUpdate(Sender: TObject);
   procedure HelpCommunityPageCommandExecute(Sender: TObject);
   procedure ProjectClearUnitCacheItemClick(Sender: TObject);
   procedure RunRunNoDebugCommandExecute(Sender: TObject);
   procedure MenuBarPopup(Sender: TObject; Item: TCustomActionControl);
   procedure MenuBarExitMenuLoop(Sender: TCustomActionMenuBar; Cancelled: Boolean);
   procedure actnDockEditWindowUpdate(Sender: TObject);
   procedure actnDockEditWindowExecute(Sender: TObject);
   procedure DockBottomPanelUnDock(Sender: TObject; Client: TControl; NewTarget: TWinControl; var Allow: Boolean);
   procedure DockBottomPanelDockDrop(Sender: TObject; Source: TDragDockObject; X: Integer; Y: Integer);
   procedure DockBottomPanelGetSiteInfo(Sender: TObject; DockClient: TControl; var InfluenceRect: TRect; MousePos: TPoint; var CanDock: Boolean);
   procedure actnCustomizeNewExecute(Sender: TObject);
   procedure ToolsGalleryCommandUpdate(Sender: TObject);
   procedure ToolsTemplateLibrariesCommandUpdate(Sender: TObject);
   procedure AlignCommandUpdate(Sender: TObject);
   procedure AlignCommandExecute(Sender: TObject);
   procedure SizeCommandExecute(Sender: TObject);
   procedure SizeCommandUpdate(Sender: TObject);
   procedure ProjectDependenciesCommandUpdate(Sender: TObject);
   procedure ProjectDependenciesCommandExecute(Sender: TObject);
   procedure MenuBarGetControlClass(Sender: TCustomActionBar; AnItem: TActionClient; var ControlClass: TCustomActionControlClass);
   procedure New1Click(Sender: TObject);
   procedure ToolbarMouseActivate(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X: Integer; Y: Integer; HitTest: Integer; var MouseActivate: TMouseActivate);
   procedure HelpSupportPageCommandExecute(Sender: TObject);
   procedure HelpContentsCommandUpdate(Sender: TObject);
   procedure ReopenPropertiesItemClick(Sender: TObject);
   procedure ProjectStopBuildCommandExecute(Sender: TObject);
   procedure FileOpenFromRepositoryUpdate(Sender: TObject);
   procedure FileOpenFromRepositoryExecute(Sender: TObject);
   procedure ComponentActionUpdate(Sender: TObject);
   procedure HelpDocRadStudioDocWikiCommandExecute(Sender: TObject);
   procedure HelpDocOSXDeveloperLibraryCommandExecute(Sender: TObject);
   procedure HelpDocWindowsPlatformSDKCommandExecute(Sender: TObject);
   procedure FormCreate(Sender: TObject);
   procedure FormDestroy(Sender: TObject);
   procedure FormEndDock(Sender: TObject; Target: TObject; X: Integer; Y: Integer);
   property ProjectNeedsSaving: Boolean;
   property Menu: TMainMenu;
   property ZombieExeName: string;
   property Action: TBasicAction;
   property ActiveControl: TWinControl;
   property Align: TAlign;
   property AlphaBlend: Boolean;
   property AlphaBlendValue: Byte;
   property Anchors: TAnchors;
   property AutoScroll: Boolean;
   property AutoSize: Boolean;
   property BiDiMode: TBiDiMode;
   property BorderIcons: TBorderIcons;
   property BorderStyle: TFormBorderStyle;
   property BorderWidth: TBorderWidth;
   property Caption: TCaption;
   property ClientHeight: Integer;
   property ClientWidth: Integer;
   property Color: TColor;
   property TransparentColor: Boolean;
   property TransparentColorValue: TColor;
   property Constraints: TSizeConstraints;
   property Ctl3D: Boolean;
   property UseDockManager: Boolean;
   property DefaultMonitor: TDefaultMonitor;
   property DockSite: Boolean;
   property DoubleBuffered: Boolean;
   property DragKind: TDragKind;
   property DragMode: TDragMode;
   property Enabled: Boolean;
   property ParentFont: Boolean;
   property Font: TFont;
   property FormStyle: TFormStyle;
   property GlassFrame: TGlassFrame;
   property Height: Integer;
   property HelpFile: string;
   property HorzScrollBar: TControlScrollBar;
   property Icon: TIcon;
   property KeyPreview: Boolean;
   property Padding: TPadding;
   property Menu: TMainMenu;
   property OldCreateOrder: Boolean;
   property ObjectMenuItem: TMenuItem;
   property ParentBiDiMode: Boolean;
   property PixelsPerInch: Integer;
   property PopupMenu: TPopupMenu;
   property PopupMode: TPopupMode;
   property PopupParent: TCustomForm;
   property Position: TPosition;
   property PrintScale: TPrintScale;
   property Scaled: Boolean;
   property ScreenSnap: Boolean;
   property ShowHint: Boolean;
   property SnapBuffer: Integer;
   property Touch: TTouchManager;
   property TipMode: TTipMode;
   property VertScrollBar: TControlScrollBar;
   property Visible: Boolean;
   property Width: Integer;
   property WindowState: TWindowState;
   property WindowMenu: TMenuItem;
   property StyleElements: TStyleElements;
   property OnActivate: TNotifyEvent;
   property OnAlignInsertBefore: TAlignInsertBeforeEvent;
   property OnAlignPosition: TAlignPositionEvent;
   property OnCanResize: TCanResizeEvent;
   property OnClick: TNotifyEvent;
   property OnClose: TCloseEvent;
   property OnCloseQuery: TCloseQueryEvent;
   property OnConstrainedResize: TConstrainedResizeEvent;
   property OnContextPopup: TContextPopupEvent;
   property OnCreate: TNotifyEvent;
   property OnDblClick: TNotifyEvent;
   property OnDestroy: TNotifyEvent;
   property OnDeactivate: TNotifyEvent;
   property OnDockDrop: TDockDropEvent;
   property OnDockOver: TDockOverEvent;
   property OnDragDrop: TDragDropEvent;
   property OnDragOver: TDragOverEvent;
   property OnEndDock: TEndDragEvent;
   property OnGesture: TGestureEvent;
   property OnGetSiteInfo: TGetSiteInfoEvent;
   property OnHide: TNotifyEvent;
   property OnHelp: THelpEvent;
   property OnKeyDown: TKeyEvent;
   property OnKeyPress: TKeyPressEvent;
   property OnKeyUp: TKeyEvent;
   property OnMouseActivate: TMouseActivateEvent;
   property OnMouseDown: TMouseEvent;
   property OnMouseEnter: TNotifyEvent;
   property OnMouseLeave: TNotifyEvent;
   property OnMouseMove: TMouseMoveEvent;
   property OnMouseUp: TMouseEvent;
   property OnMouseWheel: TMouseWheelEvent;
   property OnMouseWheelDown: TMouseWheelUpDownEvent;
   property OnMouseWheelUp: TMouseWheelUpDownEvent;
   property OnPaint: TNotifyEvent;
   property OnResize: TNotifyEvent;
   property OnShortCut: TShortCutEvent;
   property OnShow: TNotifyEvent;
   property OnStartDock: TStartDockEvent;
   property OnUnDock: TUnDockEvent;
   property Left: Integer;
   property Top: Integer;
   property OnAlignInsertBefore: TAlignInsertBeforeEvent;
   property OnAlignPosition: TAlignPositionEvent;
   property HorzScrollBar: TControlScrollBar;
   property VertScrollBar: TControlScrollBar;
   property AlignWithMargins: Boolean;
   property Left: Integer;
   property Top: Integer;
   property Width: Integer;
   property Height: Integer;
   property Cursor: TCursor;
   property Hint: string;
   property HelpType: THelpType;
   property HelpKeyword: string;
   property HelpContext: THelpContext;
   property Margins: TMargins;
   property CustomHint: TCustomHint;
   property ParentCustomHint: Boolean;
   property Name: TComponentName;
   property Tag: NativeInt;
  end;
